@extends('layout.app')

@section('meta-information')
    <title>Edit Portal</title>
@endsection

@section('main-content')
<div class="bg-white p-6">
    <h2 class="text-xl font-bold mb-4">Edit Portal</h2>

    <form action="{{ route('role.portal-management.update', ['role' => Str::slug(Auth::user()->getRoleNames()->first()), 'portal_management' => $portal->id]) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label>Name</label>
            <input type="text" name="name" required class="w-full border px-3 py-2 rounded" value="{{ old('name', $portal->name) }}">
        </div>

        <div class="mb-3">
            <label>API Key</label>
            <input type="text" name="api_key" class="w-full border px-3 py-2 rounded" value="{{ old('api_key', $portal->api_key) }}">
        </div>

        <div class="mb-3">
            <label>API Secret</label>
            <input type="text" name="api_secret" class="w-full border px-3 py-2 rounded" value="{{ old('api_secret', $portal->api_secret) }}">
        </div>

        <div class="mb-3">
            <label>Base URL</label>
            <input type="text" name="base_url" class="w-full border px-3 py-2 rounded" value="{{ old('base_url', $portal->base_url) }}">
        </div>

        <div class="mb-3">
            <label>Type</label>
            <select name="type" class="w-full border px-3 py-2 rounded">
                <option value="flight" {{ $portal->type == 'flight' ? 'selected' : '' }}>Flight</option>
                <option value="bus" {{ $portal->type == 'bus' ? 'selected' : '' }}>Bus</option>
                <option value="train" {{ $portal->type == 'train' ? 'selected' : '' }}>Train</option>
            </select>
        </div>

        <div class="mb-3">
            <label>Vendor</label>
            <select name="vendor_id" class="w-full border px-3 py-2 rounded">
                <option value="">-- Select Vendor --</option>
                @foreach($vendors as $vendor)
                    <option value="{{ $vendor->id }}" {{ $portal->vendor_id == $vendor->id ? 'selected' : '' }}>
                        {{ $vendor->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="w-full border px-3 py-2 rounded">
                <option value="active" {{ $portal->status == 'active' ? 'selected' : '' }}>Active</option>
                <option value="inactive" {{ $portal->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
            </select>
        </div>

        <div class="mt-4">
            <button class="px-4 py-2 bg-blue-600 text-white rounded cursor-pointer">Update</button>
        </div>
    </form>
</div>
@endsection
