<div id="editModal" class="modal fixed inset-0 flex items-center justify-center z-50 hidden" style="margin-top: -50px">
    <div class="modal-backdrop fixed inset-0 bg-black opacity-50"></div>
    <div class="modal-container bg-white w-11/12 md:max-w-md mx-auto rounded shadow-lg z-50 overflow-y-auto">
        <div class="modal-content py-4 text-left px-6">
            <div class="modal-header flex justify-between items-center pb-3">
                <h3 class="text-xl font-semibold">Edit Designation</h3>
                <button class="modal-close-edit z-50">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <form id="editForm" method="POST" enctype="multipart/form-data"
                    action="<?php echo e(route('role.holidays.update', ['role' => Str::slug(Auth::user()->getRoleNames()->first()), 'holiday' => 1])); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" id="editItemId" name="id">
                    <div>
                        <label for="edit_name" class="block text-gray-700 text-sm font-medium mb-2">Name</label>
                        <input type="text" id="edit_name" name="name"
                            class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-red-500 text-xs mt-1 hidden error-message">Please choose a name</p>
                    </div>                       
                    <div>
                        <label for="edit_start_date" class="block text-gray-700 text-sm font-medium mb-2">Start Date</label>
                        <input type="date" id="edit_start_date" name="start_date"
                            class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-red-500 text-xs mt-1 hidden error-message">Please choose a date</p>
                    </div>                       
                    <div>
                        <label for="edit_end_date" class="block text-gray-700 text-sm font-medium mb-2">End Date</label>
                        <input type="date" id="edit_end_date" name="end_date"
                            class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <p class="text-red-500 text-xs mt-1 hidden error-message">Please choose a date</p>
                    </div>                       
                    <div class="mt-4">
                        <label for="edit_note" class="block text-gray-700 text-sm font-medium mb-2">note</label>
                        <textarea id="edit_note" name="note" rows="4" placeholder="Enter note"
                            class="w-full rounded-md border border-gray-300 focus:border-blue-500 focus:ring-2 focus:ring-blue-100 p-3 text-sm text-gray-700 outline-none resize-none transition duration-150"></textarea>
                        <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter an note</p>
                    </div>   
                </form>
            </div>
            <div class="modal-footer flex justify-end pt-2">
                <button type="button" class="btn btn-secondary px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400 transition duration-200 mr-2 modal-close-edit">
                    Cancel
                </button>
                <button data-action="<?php echo e(route('role.holidays.update', ['role' => Str::slug(Auth::user()->getRoleNames()->first()), 'holiday' => 1])); ?>" id="editSubmit" type="button" class="btn btn-primary px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 transition duration-200">
                    Update
                </button>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\laragon\www\epal_erp\resources\views/holidays/edit-modal.blade.php ENDPATH**/ ?>